unit adjust_unit;

interface

uses
  ik121_baseunit,
  ik121_correct,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons;

type
  Tdrawer = class(TForm)
    stop_adjust: TBitBtn;
    axis: TPanel;
    Label2: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    save_button: TButton;
    auto_button: TButton;
    Label11: TLabel;
    v0: TPanel;
    v1: TPanel;
    v3: TPanel;
    v2: TPanel;
    Timer2: TTimer;
    def_button: TButton;
    procedure FormActivate(Sender: TObject);
    procedure stop_adjustClick(Sender: TObject);
    procedure axisClick(Sender: TObject);
    procedure save_buttonClick(Sender: TObject);
    procedure auto_buttonClick(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure def_buttonClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  drawer: Tdrawer;

procedure rebuild_draw(count:count_pointr);

implementation

uses ik121_unit3;

{$R *.DFM}

(******************************************************************)
(******************************************************************)
procedure rebuild_draw(count:count_pointr);
var
  ofs0,ofs9 : short;
  data,
  x         : byte;
  s         : string;
begin
  drawer.Canvas.Rectangle(1,1,256,256);

  drawer.Canvas.Pen.Color:=clblue;
  drawer.Canvas.moveto(1,1);
  drawer.Canvas.lineto(1,256);
  drawer.Canvas.lineto(256,256);
  drawer.Canvas.lineto(256,1);
  drawer.Canvas.lineto(1,1);

  drawer.Canvas.Pen.Color:=clyellow;
  drawer.Canvas.moveto(128,1);
  drawer.Canvas.lineto(128,256);
  drawer.Canvas.moveto(1,128);
  drawer.Canvas.lineto(256,128);
  drawer.Canvas.moveto(1,1);
  drawer.Canvas.lineto(256,256);
  drawer.Canvas.moveto(1,256);
  drawer.Canvas.lineto(256,1);

  (*
  drawer.Canvas.textout(2,130,'Okt.0');
  drawer.Canvas.textout(2,110,'Okt.1');
  *)

  x:=count^.axis;
  str(x,s);
  drawer.axis.caption:=s;

  Status:=ikreadoffset(x,@ofs0,@ofs9);
  str(ofs0,s);
  drawer.v0.Caption:=s;
  str(ofs9,s);
  drawer.v1.Caption:=s;

  Status:=ikreadphase(x,@data);
  str(data,s);
  drawer.v2.Caption:=s;

  Status:=ikreadamp(x,@data);
  str(data,s);
  drawer.v3.Caption:=s;

end;
(******************************************************************)
(* Draw                                                           *)
(******************************************************************)
procedure draw_ad;
var
 i,r           : byte;
 a,b           : double;
 x,y,j         : word;
begin
  i:=count^.axis;
  drawer.Canvas.Pen.Color:=clgreen;

  for j:=0 to 7 do
    begin
      for r:=0 to val_in_okt do
        begin
          a:=ik_ad[i].oktant[j].wert[r].dg00;
          b:=ik_ad[i].oktant[j].wert[r].dg90;

          a := 0.8*(a * 128)+128;
          b := 0.8*(b * 128)+128;
          x:=round(a);
          y:=round(b);

          if x<=0  then x:=0;
          if x>256 then x:=256;
          if y<=0  then y:=0;
          if y>256 then y:=256;
          drawer.Canvas.moveto(x,y);
          drawer.Canvas.lineto(x+1,y+1);
        end;
    end;
end;
(******************************************************************)
procedure offxadjust(count:count_pointr);
var
  i         : byte;
  ofx       : real;
  ofs0,ofs9 : short;
begin
  i:=count^.axis;
  ofx:=ik_ad[i].of0;
  Status:=ikreadoffset(i,@ofs0,@ofs9);
  if ofx>0 then
    begin
      if ofs0<63 then ofs0:=ofs0-1;
    end
  else
    begin
      if ofs0>-63 then ofs0:=ofs0+1;
    end;
  Status:=ikwriteoffset(i,ofs0,ofs9);
end;
(******************************************************************)
procedure offyadjust(count:count_pointr);
var
  i         : byte;
  ofy       : real;
  ofs0,ofs9 : short;
begin
  i:=count^.axis;
  ofy:=ik_ad[i].of9;
  Status:=ikreadoffset(i,@ofs0,@ofs9);
  if ofy>0 then
    begin
      if ofs9<63 then ofs9:=ofs9-1;
    end
  else
    begin
      if ofs9>-62 then ofs9:=ofs9+1;
    end;
  Status:=ikwriteoffset(i,ofs0,ofs9);
end;
(******************************************************************)
procedure phaseadjust(count:count_pointr);
var
  i         : byte;
  phas      : real;
  data      : byte;
begin
  i:=count^.axis;
  phas:=ik_ad[i].phas;
  Status:=ikreadphase(i,@data);
  if phas>0 then
    begin
      if data<63 then data:=data+1;
    end
  else
    begin
      if data>0 then data:=data-1;
    end;
  Status:=ikwritephase(i,data);
end;
(******************************************************************)
procedure symadjust(count:count_pointr);
var
  i         : byte;
  sym       : real;
  data      : byte;
begin
  i:=count^.axis;
  sym:=ik_ad[i].sym;
  Status:=ikreadamp(i,@data);
  if sym>1 then
    begin
      if data<63 then data:=data+1;
    end
  else
    begin
      if data>0 then data:=data-1;
    end;
  Status:=ikwriteamp(i,data);
end;
(******************************************************************)
(* Correct potentiometer values                                   *)
(******************************************************************)
procedure Tdrawer.Timer2Timer(Sender: TObject);
var
  i : byte;
begin

  i:=count^.axis;
  if (ik_ad[i].samp_req and ik_ad[i].samp_rdy) then
    begin
     if autoadjust then
         begin
           offxadjust(count);
           offyadjust(count);
           phaseadjust(count);
           symadjust(count);
         end;
      rebuild_draw(count);
      draw_ad;
      ik_ad[i].samp_req:=false;
    end;

  if not(ik_ad[i].samp_req) and not(ik_ad[i].samp_rdy) then
    begin
      ik_ad[i].samp_req:=true;
    end;

end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.FormActivate(Sender: TObject);
begin
  rebuild_draw(count);
  autoadjust:=false;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.axisClick(Sender: TObject);
begin
  autoadjust:=false;
  count^.axis:=count^.axis+1;
  if count^.axis>count^.axisnumber then
    begin
      count^.axis:=0;
    end;
  rebuild_draw(count);
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.stop_adjustClick(Sender: TObject);
begin
  drawer.hide;
  autoadjust:=false;
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.save_buttonClick(Sender: TObject);
begin
  autoadjust:=false;
  Status:=IKstore(count^.axis);
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.auto_buttonClick(Sender: TObject);
begin
  autoadjust:=not(autoadjust);
end;
(******************************************************************)
(******************************************************************)
procedure Tdrawer.def_buttonClick(Sender: TObject);
var
  x : byte;
begin
  x:=count^.axis;
  autoadjust:=false;
  Status:=ikdefault(x);
  rebuild_draw(count);
end;
(******************************************************************)
(******************************************************************)
end.
